<h1>Post an ad</h1>
<form method="post" action="/post-ad" enctype="multipart/form-data" class="grid">
  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>"/>

  <label>Category
    <select name="category_id" required>
      <?php foreach ($cats as $c): ?>
        <option value="<?= (int)$c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </label>

  <label>Title
    <input name="title" maxlength="255" required>
  </label>

  <label>Description
    <textarea name="description" rows="7" required></textarea>
  </label>

  <label>Price
    <input name="price" type="number" step="0.01" min="0" value="0">
  </label>

  <div class="split">
    <label>State
      <input name="state" placeholder="NY" maxlength="10" required>
    </label>
    <label>City
      <input name="city" placeholder="New York" maxlength="80" required>
    </label>
  </div>

  <label>Country
    <input name="country" value="US" maxlength="50">
  </label>

  <label>Images (JPG/PNG/WEBP)
    <input name="images[]" type="file" accept="image/jpeg,image/png,image/webp" multiple>
    <small class="muted">Max size per image: <?= (int)(\App\Config::get('UPLOAD_MAX_MB','8')) ?>MB</small>
  </label>

  <button class="btn">Submit for approval</button>
</form>
