<h1>Dashboard</h1>

<?php if (empty($user['email_verified_at'])): ?>
  <div class="card warn">
    <strong>Email not verified.</strong>
    <p class="muted">Verify your email before posting ads.</p>
    <form method="post" action="/resend-verification">
      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>"/>
      <button class="btn">Resend verification email</button>
    </form>
  </div>
<?php endif; ?>

<div class="row gap mt">
  <a class="btn" href="/post-ad">Post an ad</a>
  <a class="btn ghost" href="/browse">Browse</a>
</div>

<h3 class="mt">Your ads</h3>
<?php if (!$ads): ?>
  <p class="muted">No ads yet.</p>
<?php else: ?>
  <div class="list">
    <?php foreach ($ads as $a): ?>
      <div class="listitem">
        <div class="row between">
          <div class="title"><?= htmlspecialchars($a['title']) ?></div>
          <div class="pill <?= htmlspecialchars($a['status']) ?>"><?= htmlspecialchars($a['status']) ?></div>
        </div>
        <div class="meta"><?= htmlspecialchars($a['category_name']) ?> • <?= htmlspecialchars($a['location_city']) ?>, <?= htmlspecialchars($a['location_state']) ?> • $<?= number_format((float)$a['price'], 2) ?></div>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
