<section class="hero compact">
  <h1><?= htmlspecialchars($tenant['name'] ?? 'Marketplace') ?></h1>
  <p class="muted">Browse verified, admin-approved listings.</p>
  <form class="row gap" action="/browse" method="get">
    <input name="q" placeholder="Search listings...">
    <button class="btn">Search</button>
    <?php if ($user): ?><a class="btn ghost" href="/post-ad">Post an ad</a><?php endif; ?>
  </form>
</section>

<div class="grid2 mt">
  <div class="card">
    <h3>Categories</h3>
    <div class="chips">
      <?php foreach ($cats as $c): ?>
        <a class="chip" href="/browse?category=<?= (int)$c['id'] ?>"><?= htmlspecialchars($c['name']) ?></a>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="card">
    <h3>Latest listings</h3>
    <?php if (!$ads): ?>
      <p class="muted">No approved ads yet.</p>
    <?php else: ?>
      <div class="list">
        <?php foreach ($ads as $a): ?>
          <a class="listitem" href="/ad?id=<?= (int)$a['id'] ?>">
            <div class="title"><?= htmlspecialchars($a['title']) ?></div>
            <div class="meta"><?= htmlspecialchars($a['category_name']) ?> • <?= htmlspecialchars($a['location_city']) ?>, <?= htmlspecialchars($a['location_state']) ?> • $<?= number_format((float)$a['price'], 2) ?></div>
          </a>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
