<h1>Browse listings</h1>

<form class="card grid" method="get" action="/browse">
  <div class="split">
    <label>Search
      <input name="q" value="<?= htmlspecialchars((string)$q) ?>" placeholder="e.g., iPhone, apartment, plumber">
    </label>
    <label>Category
      <select name="category">
        <option value="0">All</option>
        <?php foreach ($cats as $c): ?>
          <option value="<?= (int)$c['id'] ?>" <?= ((int)$category === (int)$c['id']) ? 'selected' : '' ?>>
            <?= htmlspecialchars($c['name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </label>
  </div>

  <div class="split">
    <label>State
      <input name="state" value="<?= htmlspecialchars((string)$state) ?>" placeholder="NY">
    </label>
    <label>City
      <input name="city" value="<?= htmlspecialchars((string)$city) ?>" placeholder="New York">
    </label>
  </div>

  <div class="split">
    <label>Min price
      <input name="min" value="<?= htmlspecialchars((string)$min) ?>" placeholder="0">
    </label>
    <label>Max price
      <input name="max" value="<?= htmlspecialchars((string)$max) ?>" placeholder="1000">
    </label>
  </div>

  <div class="row gap">
    <button class="btn">Apply filters</button>
    <a class="btn ghost" href="/browse">Reset</a>
  </div>
</form>

<div class="mt">
  <?php if (!$ads): ?>
    <p class="muted">No results.</p>
  <?php else: ?>
    <div class="list">
      <?php foreach ($ads as $a): ?>
        <a class="listitem" href="/ad?id=<?= (int)$a['id'] ?>">
          <div class="row between">
            <div class="title"><?= htmlspecialchars($a['title']) ?></div>
            <div class="price">$<?= number_format((float)$a['price'], 2) ?></div>
          </div>
          <div class="meta"><?= htmlspecialchars($a['category_name']) ?> • <?= htmlspecialchars($a['location_city']) ?>, <?= htmlspecialchars($a['location_state']) ?></div>
        </a>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>
