<h1><?= htmlspecialchars($ad['title']) ?></h1>
<div class="muted"><?= htmlspecialchars($ad['category_name']) ?> • <?= htmlspecialchars($ad['location_city']) ?>, <?= htmlspecialchars($ad['location_state']) ?></div>
<div class="price big">$<?= number_format((float)$ad['price'], 2) ?></div>

<?php if ($images): ?>
  <div class="gallery mt">
    <?php foreach ($images as $img): ?>
      <img src="<?= htmlspecialchars($img['path']) ?>" alt="Ad image">
    <?php endforeach; ?>
  </div>
<?php endif; ?>

<div class="card mt">
  <h3>Description</h3>
  <p><?= nl2br(htmlspecialchars($ad['description'])) ?></p>
</div>

<div class="card mt">
  <h3>Seller</h3>
  <p><?= htmlspecialchars($ad['seller_name']) ?></p>
</div>
