<h1>Admin dashboard</h1>

<div class="grid3 mt">
  <div class="card"><div class="kpi"><?= (int)$pendingCount ?></div><div class="muted">Pending ads</div></div>
  <div class="card"><div class="kpi"><?= (int)$approved7d ?></div><div class="muted">Approved (7d)</div></div>
  <div class="card"><div class="kpi"><?= (int)$newUsers7d ?></div><div class="muted">New users (7d)</div></div>
</div>

<div class="grid2 mt">
  <div class="card">
    <h3>Top categories</h3>
    <?php if (!$topCats): ?><p class="muted">No data yet.</p><?php endif; ?>
    <?php foreach ($topCats as $r): ?>
      <div class="row between"><div><?= htmlspecialchars($r['name']) ?></div><div class="pill"><?= (int)$r['c'] ?></div></div>
    <?php endforeach; ?>
  </div>

  <div class="card">
    <h3>Top locations</h3>
    <?php if (!$topLocations): ?><p class="muted">No data yet.</p><?php endif; ?>
    <?php foreach ($topLocations as $r): ?>
      <div class="row between"><div><?= htmlspecialchars($r['loc']) ?></div><div class="pill"><?= (int)$r['c'] ?></div></div>
    <?php endforeach; ?>
  </div>
</div>

<h3 class="mt">Pending approvals</h3>
<?php if (!$pending): ?>
  <p class="muted">No pending ads.</p>
<?php else: ?>
  <div class="list">
    <?php foreach ($pending as $a): ?>
      <div class="listitem">
        <div class="row between">
          <div class="title"><?= htmlspecialchars($a['title']) ?></div>
          <div class="muted"><?= htmlspecialchars($a['category_name']) ?></div>
        </div>
        <div class="meta">
          By <?= htmlspecialchars($a['user_name']) ?> (<?= htmlspecialchars($a['email']) ?>) •
          <?= htmlspecialchars($a['location_city']) ?>, <?= htmlspecialchars($a['location_state']) ?> •
          $<?= number_format((float)$a['price'], 2) ?>
        </div>
        <div class="mt">
          <form method="post" action="/admin/moderate" class="row gap">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>"/>
            <input type="hidden" name="ad_id" value="<?= (int)$a['id'] ?>"/>
            <input name="reason" placeholder="Reason (optional)" class="grow">
            <button class="btn" name="action" value="approved">Approve</button>
            <button class="btn danger" name="action" value="rejected">Reject</button>
          </form>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
