<?php
$rootDomain = \App\Config::get('APP_ROOT_DOMAIN', '');
$tenant = $tenant ?? \App\Tenant::current();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1"/>
  <title><?= htmlspecialchars(\App\Config::get('APP_NAME','Classifieds SaaS')) ?></title>
  <link rel="stylesheet" href="/assets/styles.css"/>
</head>
<body>
<header class="topbar">
  <div class="wrap row">
    <div class="brand">
      <a href="/"><?= htmlspecialchars($tenant['name'] ?? \App\Config::get('APP_NAME','Classifieds SaaS')) ?></a>
      <?php if ($tenant): ?><span class="pill">Tenant</span><?php endif; ?>
    </div>

    <nav class="nav">
      <?php if ($tenant): ?>
        <a href="/browse">Browse</a>
        <?php if ($user): ?>
          <a href="/dashboard">Dashboard</a>
          <?php if (($user['role'] ?? '') === 'admin'): ?><a href="/admin">Admin</a><?php endif; ?>
          <form method="post" action="/logout" class="inline">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>"/>
            <button class="linkbtn">Logout</button>
          </form>
        <?php else: ?>
          <a href="/login">Login</a>
          <a class="btn" href="/register">Create account</a>
        <?php endif; ?>
      <?php else: ?>
        <a href="/create-marketplace">Create Marketplace</a>
      <?php endif; ?>
    </nav>
  </div>
</header>

<main class="wrap">
  <?php if ($flash): ?>
    <div class="flash <?= htmlspecialchars($flash['type']) ?>">
      <?= htmlspecialchars($flash['msg']) ?>
    </div>
  <?php endif; ?>
