<?php
// Safer uploads serving for shared hosting: maps /uploads/... to /storage/... and streams file.
// In production, prefer direct static serving via proper docroot + permissions.
$path = $_SERVER['REQUEST_URI'] ?? '';
$path = preg_replace('#^/uploads/#', '', $path);
$path = str_replace(['..','\\'], '', $path);

$full = __DIR__ . '/../../storage/' . $path;
if (!is_file($full)) { http_response_code(404); exit; }

$mime = mime_content_type($full) ?: 'application/octet-stream';
header('Content-Type: '.$mime);
header('Content-Length: '.filesize($full));
readfile($full);
