<?php
declare(strict_types=1);

require __DIR__ . '/../app/bootstrap.php';

use App\Router;
use App\Middleware\AuthMiddleware;
use App\Middleware\AdminMiddleware;

$router = new Router();

$router->get('/', 'App\Controllers\PublicController@home');
$router->get('/browse', 'App\Controllers\PublicController@browse');
$router->get('/ad', 'App\Controllers\PublicController@viewAd'); // ?id=
$router->get('/state', 'App\Controllers\PublicController@byState'); // ?state=
$router->get('/city', 'App\Controllers\PublicController@byCity'); // ?state=&city=

$router->get('/register', 'App\Controllers\AuthController@showRegister');
$router->post('/register', 'App\Controllers\AuthController@register');
$router->get('/login', 'App\Controllers\AuthController@showLogin');
$router->post('/login', 'App\Controllers\AuthController@login');
$router->post('/logout', 'App\Controllers\AuthController@logout');
$router->get('/verify-email', 'App\Controllers\AuthController@verifyEmail'); // ?token=
$router->post('/resend-verification', 'App\Controllers\AuthController@resendVerification', [new AuthMiddleware()]);

$router->get('/dashboard', 'App\Controllers\UserController@dashboard', [new AuthMiddleware()]);
$router->get('/post-ad', 'App\Controllers\AdController@showPost', [new AuthMiddleware()]);
$router->post('/post-ad', 'App\Controllers\AdController@post', [new AuthMiddleware()]);

$router->get('/admin', 'App\Controllers\AdminController@dashboard', [new AuthMiddleware(), new AdminMiddleware()]);
$router->post('/admin/moderate', 'App\Controllers\AdminController@moderateAd', [new AuthMiddleware(), new AdminMiddleware()]);

// SaaS: create marketplace on root domain
$router->get('/create-marketplace', 'App\Controllers\SaaSController@showCreateMarketplace');
$router->post('/create-marketplace', 'App\Controllers\SaaSController@createMarketplace');
$router->get('/billing', 'App\Controllers\SaaSController@billing', [new AuthMiddleware()]);
$router->post('/billing/checkout', 'App\Controllers\SaaSController@checkout', [new AuthMiddleware()]);

// Stripe webhooks
$router->post('/webhooks/stripe', 'App\Controllers\WebhookController@stripe');

$router->dispatch();
