<?php
declare(strict_types=1);

spl_autoload_register(function ($class) {
  $prefix = 'App\\';
  if (str_starts_with($class, $prefix)) {
    $rel = substr($class, strlen($prefix));
    $path = __DIR__ . '/' . str_replace('\\', '/', $rel) . '.php';
    if (file_exists($path)) require $path;
  }
});

use App\Config;
use App\DB;
use App\Tenant;

Config::load(__DIR__ . '/../.env');

date_default_timezone_set('UTC');

session_name(Config::get('SESSION_COOKIE', 'classifieds_saas_session'));
session_start();

// CSRF token
if (empty($_SESSION['csrf'])) {
  $_SESSION['csrf'] = bin2hex(random_bytes(32));
}

// Connect DB
DB::init([
  'host' => Config::get('DB_HOST'),
  'name' => Config::get('DB_NAME'),
  'user' => Config::get('DB_USER'),
  'pass' => Config::get('DB_PASS'),
]);

// Resolve tenant from subdomain
Tenant::resolveFromHost($_SERVER['HTTP_HOST'] ?? '');
