<?php
declare(strict_types=1);

namespace App;

final class View {
  public static function render(string $view, array $data=[]): void {
    extract($data, EXTR_SKIP);
    $tenant = Tenant::current();
    $user = Auth::user();
    $csrf = $_SESSION['csrf'] ?? '';
    $flash = $_SESSION['flash'] ?? null;
    unset($_SESSION['flash']);
    require __DIR__ . '/../views/_layout/header.php';
    require __DIR__ . '/../views/' . $view . '.php';
    require __DIR__ . '/../views/_layout/footer.php';
  }

  public static function redirect(string $path): void {
    header("Location: $path");
    exit;
  }

  public static function flash(string $type, string $msg): void {
    $_SESSION['flash'] = ['type' => $type, 'msg' => $msg];
  }
}
