<?php
declare(strict_types=1);

namespace App;

final class Tenant {
  private static ?array $tenant = null;

  public static function resolveFromHost(string $host): void {
    $host = strtolower(trim($host));
    $host = preg_replace('/:\d+$/', '', $host); // strip port

    $root = strtolower(Config::get('APP_ROOT_DOMAIN', $host));
    $root = preg_replace('/^www\./', '', $root);

    // If host == root or www.root → no tenant
    $cleanHost = preg_replace('/^www\./', '', $host);
    if ($cleanHost === $root) {
      self::$tenant = null;
      return;
    }

    // Extract subdomain as tenant slug: <slug>.<root>
    if (!str_ends_with($cleanHost, '.' . $root)) {
      // Host mismatch; treat as root
      self::$tenant = null;
      return;
    }

    $slug = substr($cleanHost, 0, -1 * (strlen($root) + 1));
    // Keep first label only (miami.us.yourdomain.com -> miami)
    $slug = explode('.', $slug)[0];

    if (!$slug || in_array($slug, ['www'], true)) {
      self::$tenant = null;
      return;
    }

    $t = DB::one("SELECT * FROM tenants WHERE slug = ? AND status = 'active' LIMIT 1", [$slug]);
    self::$tenant = $t;
  }

  public static function current(): ?array {
    return self::$tenant;
  }

  public static function requireTenant(): void {
    if (!self::$tenant) {
      http_response_code(404);
      View::render('public/no-tenant', []);
      exit;
    }
  }
}
