<?php
declare(strict_types=1);

namespace App;

final class Router {
  private array $routes = ['GET'=>[], 'POST'=>[]];

  public function get(string $path, string $handler, array $middleware=[]): void {
    $this->routes['GET'][$path] = [$handler, $middleware];
  }
  public function post(string $path, string $handler, array $middleware=[]): void {
    $this->routes['POST'][$path] = [$handler, $middleware];
  }

  public function dispatch(): void {
    $method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
    $uri = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?: '/';

    $match = $this->routes[$method][$uri] ?? null;
    if (!$match) {
      http_response_code(404);
      View::render('public/404', []);
      return;
    }
    [$handler, $middleware] = $match;

    foreach ($middleware as $mw) {
      $mw->handle();
    }

    [$class, $action] = explode('@', $handler);
    $c = new $class();
    $c->$action();
  }
}
