<?php
declare(strict_types=1);

namespace App\Middleware;

use App\Auth;
use App\Tenant;
use App\View;

final class AdminMiddleware {
  public function handle(): void {
    $u = Auth::user();
    $t = Tenant::current();
    if (!$u || !$t) {
      View::redirect('/');
    }
    if (($u['role'] ?? '') !== 'admin') {
      http_response_code(403);
      echo "Admin only.";
      exit;
    }
    if ((int)$u['tenant_id'] !== (int)$t['id']) {
      http_response_code(403);
      echo "Cross-tenant access denied.";
      exit;
    }
  }
}
