<?php
declare(strict_types=1);

namespace App\Helpers;

use App\Config;

final class Uploads {
  public static function maxBytes(): int {
    $mb = (int)Config::get('UPLOAD_MAX_MB', '8');
    return max(1, $mb) * 1024 * 1024;
  }

  public static function isValidImage(array $file): bool {
    if (($file['error'] ?? UPLOAD_ERR_NO_FILE) !== UPLOAD_ERR_OK) return false;
    if (($file['size'] ?? 0) <= 0 || ($file['size'] ?? 0) > self::maxBytes()) return false;
    $finfo = new \finfo(FILEINFO_MIME_TYPE);
    $mime = $finfo->file($file['tmp_name']);
    return in_array($mime, ['image/jpeg','image/png','image/webp'], true);
  }

  public static function extFromMime(string $mime): string {
    return match($mime) {
      'image/jpeg' => 'jpg',
      'image/png' => 'png',
      'image/webp' => 'webp',
      default => 'bin',
    };
  }
}
