<?php
declare(strict_types=1);

namespace App\Helpers;

use App\Config;

final class Mailer {
  // Simple SMTP via PHP's mail() fallback.
  // For best deliverability: wire to an SMTP library (PHPMailer). This starter keeps dependencies zero.
  public static function send(string $to, string $subject, string $html): bool {
    $from = Config::get('MAIL_FROM', 'no-reply@localhost');
    $fromName = Config::get('MAIL_FROM_NAME', 'Classifieds SaaS');

    $headers = [];
    $headers[] = "MIME-Version: 1.0";
    $headers[] = "Content-type:text/html;charset=UTF-8";
    $headers[] = "From: {$fromName} <{$from}>";

    return @mail($to, $subject, $html, implode("\r\n", $headers));
  }
}
