<?php
declare(strict_types=1);

namespace App;

use PDO;
use PDOException;

final class DB {
  private static ?PDO $pdo = null;

  public static function init(array $cfg): void {
    $dsn = "mysql:host={$cfg['host']};dbname={$cfg['name']};charset=utf8mb4";
    try {
      self::$pdo = new PDO($dsn, $cfg['user'], $cfg['pass'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      ]);
    } catch (PDOException $e) {
      http_response_code(500);
      echo "Database connection failed.";
      exit;
    }
  }

  public static function pdo(): PDO {
    return self::$pdo;
  }

  public static function q(string $sql, array $params=[]): array {
    $st = self::pdo()->prepare($sql);
    $st->execute($params);
    return $st->fetchAll();
  }

  public static function one(string $sql, array $params=[]): ?array {
    $st = self::pdo()->prepare($sql);
    $st->execute($params);
    $row = $st->fetch();
    return $row === false ? null : $row;
  }

  public static function exec(string $sql, array $params=[]): int {
    $st = self::pdo()->prepare($sql);
    $st->execute($params);
    return (int)self::pdo()->lastInsertId();
  }
}
