<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Auth;
use App\DB;
use App\Tenant;
use App\View;

final class UserController {
  public function dashboard(): void {
    Tenant::requireTenant();
    $tenant = Tenant::current();
    $u = Auth::user();

    // refresh user from DB for accurate email_verified_at
    $fresh = DB::one("SELECT * FROM users WHERE id=? AND tenant_id=? LIMIT 1", [$u['id'], $tenant['id']]);
    if ($fresh) Auth::login($fresh);
    $u = Auth::user();

    $ads = DB::q("SELECT a.*, c.name AS category_name
                 FROM ads a
                 JOIN categories c ON c.id=a.category_id
                 WHERE a.tenant_id=? AND a.user_id=?
                 ORDER BY a.created_at DESC
                 LIMIT 200", [$tenant['id'], $u['id']]);

    View::render('user/dashboard', compact('ads'));
  }
}
