<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Auth;
use App\DB;
use App\Tenant;
use App\View;

final class AdminController {
  public function dashboard(): void {
    Tenant::requireTenant();
    $tenant = Tenant::current();

    $pending = DB::q("SELECT a.*, u.name AS user_name, u.email, c.name AS category_name
                     FROM ads a
                     JOIN users u ON u.id=a.user_id
                     JOIN categories c ON c.id=a.category_id
                     WHERE a.tenant_id=? AND a.status='pending'
                     ORDER BY a.created_at ASC", [$tenant['id']]);

    // analytics
    $pendingCount = DB::one("SELECT COUNT(*) AS c FROM ads WHERE tenant_id=? AND status='pending'", [$tenant['id']])['c'] ?? 0;
    $approved7d = DB::one("SELECT COUNT(*) AS c FROM ads WHERE tenant_id=? AND status='approved' AND created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)", [$tenant['id']])['c'] ?? 0;
    $newUsers7d = DB::one("SELECT COUNT(*) AS c FROM users WHERE tenant_id=? AND created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)", [$tenant['id']])['c'] ?? 0;

    $topCats = DB::q("SELECT c.name, COUNT(*) AS c
                     FROM ads a JOIN categories c ON c.id=a.category_id
                     WHERE a.tenant_id=? AND a.status='approved'
                     GROUP BY c.id ORDER BY c DESC LIMIT 8", [$tenant['id']]);

    $topLocations = DB::q("SELECT CONCAT(location_city, ', ', location_state) AS loc, COUNT(*) AS c
                          FROM ads
                          WHERE tenant_id=? AND status='approved'
                          GROUP BY loc ORDER BY c DESC LIMIT 8", [$tenant['id']]);

    View::render('admin/dashboard', compact('pending','pendingCount','approved7d','newUsers7d','topCats','topLocations'));
  }

  public function moderateAd(): void {
    Auth::checkCsrf();
    Tenant::requireTenant();
    $tenant = Tenant::current();
    $u = Auth::user();

    $adId = (int)($_POST['ad_id'] ?? 0);
    $action = (string)($_POST['action'] ?? '');
    $reason = trim((string)($_POST['reason'] ?? ''));

    if (!in_array($action, ['approved','rejected'], true) || $adId <= 0) {
      View::redirect('/admin');
    }

    DB::exec("UPDATE ads SET status=? WHERE id=? AND tenant_id=? LIMIT 1", [$action, $adId, $tenant['id']]);
    DB::exec("INSERT INTO ad_moderation_logs (tenant_id, ad_id, admin_user_id, action, reason) VALUES (?,?,?,?,?)",
      [$tenant['id'], $adId, $u['id'], $action, $reason]
    );

    View::flash('success', "Ad {$action}.");
    View::redirect('/admin');
  }
}
