<?php
declare(strict_types=1);

namespace App;

final class Config {
  private static array $data = [];

  public static function load(string $path): void {
    if (!file_exists($path)) return;
    $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
      $line = trim($line);
      if ($line === '' || str_starts_with($line, '#')) continue;
      $pos = strpos($line, '=');
      if ($pos === false) continue;
      $key = trim(substr($line, 0, $pos));
      $val = trim(substr($line, $pos + 1));
      $val = trim($val, ""'");
      self::$data[$key] = $val;
    }
    // Provide a default APP_KEY if missing (still recommend setting it!)
    if (!isset(self::$data['APP_KEY']) || strlen(self::$data['APP_KEY']) < 16) {
      self::$data['APP_KEY'] = bin2hex(random_bytes(32));
    }
  }

  public static function get(string $key, mixed $default=null): mixed {
    return self::$data[$key] ?? $default;
  }

  public static function bool(string $key, bool $default=false): bool {
    $v = strtolower((string)(self::$data[$key] ?? ''));
    if ($v === '') return $default;
    return in_array($v, ['1','true','yes','on'], true);
  }
}
