<?php
declare(strict_types=1);

namespace App;

final class Auth {
  public static function user(): ?array {
    return $_SESSION['user'] ?? null;
  }

  public static function login(array $user): void {
    unset($user['password_hash']);
    $_SESSION['user'] = $user;
  }

  public static function logout(): void {
    unset($_SESSION['user']);
  }

  public static function checkCsrf(): void {
    $token = $_POST['csrf'] ?? '';
    if (!$token || !hash_equals($_SESSION['csrf'] ?? '', $token)) {
      http_response_code(419);
      echo "Invalid CSRF token.";
      exit;
    }
  }

  public static function requireVerifiedEmail(): void {
    $u = self::user();
    if (!$u) return;
    if (empty($u['email_verified_at'])) {
      View::flash('error', 'Please verify your email before posting ads.');
      View::redirect('/dashboard');
    }
  }
}
