# Classifieds SaaS (Subdomain Tenants) — PHP + MySQL (cPanel-friendly)

This is a lightweight, production-lean starter codebase for a SaaS-style classifieds marketplace where **each tenant is a subdomain**:

- `tenant1.yourdomain.com` (tenant marketplace)
- `tenant2.yourdomain.com` (tenant marketplace)
- `yourdomain.com` (marketing + create marketplace)

Features included:
- Multi-tenant by **subdomain**
- User auth (register/login/logout) per tenant
- **Email verification** required before posting ads
- Post ads with **image uploads** (multiple images)
- Ads are **pending** until approved by tenant admin
- Public browse + **search & filters**
- **Location-based browsing** (state/city)
- Admin dashboard: approve/reject + **analytics**
- SaaS billing (Stripe) **starter integration**: Checkout + webhooks + plan limits (basic)

---

## 1) cPanel Setup (Subdomain SaaS)

### A) Wildcard subdomain
In cPanel:
1. Create an **A record** for `*` (wildcard) to your server IP in DNS (often via your DNS provider).
2. In cPanel → **Subdomains**, create `*` (wildcard subdomain) and point it to this app's `/public` directory.
   - Example document root: `/public_html/classifieds/public`

### B) PHP version + extensions
Enable PHP 8.1+ and common extensions: `pdo_mysql`, `openssl`, `mbstring`, `fileinfo`, `curl`.

### C) Database
Create a MySQL database + user and import `database/schema.sql`.

### D) Environment
Copy `.env.example` to `.env` and fill values.

### E) Mail
Set SMTP in `.env` (recommended). If you don't have SMTP, you can start with PHP mail() but SMTP is far more reliable.

### F) Stripe (optional but included)
Add Stripe keys to `.env` and set webhook endpoint:
`https://yourdomain.com/webhooks/stripe`

---

## 2) Tenant Resolution
The tenant is resolved from the **left-most label** of the host:
- `miami.yourdomain.com` → tenant slug = `miami`
- Root host (no subdomain) shows marketing + "Create Marketplace"

You can control which hosts count as "root" in `.env` via `APP_ROOT_DOMAIN`.

---

## 3) Default Admin
When a tenant is created, the creator becomes that tenant's **admin**.

---

## 4) Security Notes
- Passwords are hashed (bcrypt).
- CSRF tokens are enabled for POST forms.
- File uploads are validated (type/size).
- You should run behind HTTPS.

---

## 5) Directory Structure

- `public/` — web root (point cPanel here)
- `app/` — controllers, middleware, helpers
- `views/` — simple PHP templates
- `storage/` — uploads (ensure writable)
- `database/` — schema + seed

---

## 6) Quick Start
1. Upload this project to your hosting.
2. Point domain + wildcard subdomain docroot to `/public`.
3. Import `database/schema.sql`.
4. Configure `.env`.
5. Visit your root domain, create a marketplace, then open `slug.yourdomain.com`.

