<?php
if (file_exists(__DIR__ . '/install.lock')) {
  die('Installer locked.');
}

$data = $_POST;

$appKey = bin2hex(random_bytes(32));

$env = <<<ENV
APP_NAME="Classifieds SaaS"
APP_ENV=production
APP_URL={$data['app_url']}
APP_ROOT_DOMAIN={$data['root_domain']}
APP_KEY={$appKey}

DB_HOST={$data['db_host']}
DB_NAME={$data['db_name']}
DB_USER={$data['db_user']}
DB_PASS={$data['db_pass']}

UPLOAD_MAX_MB=8
STRIPE_ENABLED=false
ENV;

file_put_contents(__DIR__ . '/../.env', $env);

$pdo = new PDO(
  "mysql:host={$data['db_host']};dbname={$data['db_name']};charset=utf8mb4",
  $data['db_user'],
  $data['db_pass'],
  [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
);

$schema = file_get_contents(__DIR__ . '/../database/schema.sql');
$pdo->exec($schema);

$pdo->exec("
INSERT INTO tenants (name, slug, plan_id, status)
VALUES ('Main Marketplace', 'main', 1, 'active')
");

$hash = password_hash($data['admin_password'], PASSWORD_BCRYPT);
$pdo->prepare("
INSERT INTO users (tenant_id, name, email, password_hash, role, email_verified_at)
VALUES (1, 'Super Admin', ?, ?, 'admin', NOW())
")->execute([$data['admin_email'], $hash]);

file_put_contents(__DIR__ . '/install.lock', 'installed');

header('Location: ' . $data['app_url']);
exit;
